<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");
header("Access-Control-Allow-Credentials: true");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['status' => 'error', 'message' => 'Method not allowed']);
    exit;
}

include_once '../connection.php';

try {
    $input = json_decode(file_get_contents('php://input'), true);
    
    if (!isset($input['user_id']) || !isset($input['notification_id']) || !isset($input['user_role'])) {
        http_response_code(400);
        echo json_encode(['status' => 'error', 'message' => 'Missing required parameters']);
        exit;
    }
    
    $userId = $input['user_id'];
    $notificationId = $input['notification_id'];
    $userRole = $input['user_role'];
    
         // Only Admin and Super Admin can mark notifications as seen
     if ($userRole !== 'SuperAdmin' && $userRole !== 'Super Admin' && $userRole !== 'Admin') {
        http_response_code(403);
                 echo json_encode(['status' => 'error', 'message' => 'Only Admin and Super Admin can mark notifications as seen']);
        exit;
    }
    
    $conn->beginTransaction();
    
    // Mark notification as seen by inserting into admin views table
    $stmt = $conn->prepare("
        INSERT INTO tbl_notification_admin_views (user_id, notification_id)
        VALUES (?, ?)
        ON DUPLICATE KEY UPDATE viewed_at = NOW()
    ");
    $stmt->execute([$userId, $notificationId]);
    
    // Get the current unseen count for this admin
    $stmt = $conn->prepare("
        SELECT COUNT(*) AS unseen_count
        FROM tbl_notifications n
        LEFT JOIN tbl_notification_admin_views v
          ON v.notification_id = n.notification_id AND v.user_id = ?
        WHERE v.notification_id IS NULL
    ");
    $stmt->execute([$userId]);
    $unseenCount = $stmt->fetch(PDO::FETCH_ASSOC)['unseen_count'];
    
    $conn->commit();
    
    echo json_encode([
        'status' => 'success',
        'message' => 'Notification marked as seen successfully',
        'unseen_count' => (int)$unseenCount
    ]);
    
} catch (PDOException $e) {
    if ($conn->inTransaction()) {
        $conn->rollBack();
    }
    http_response_code(500);
    echo json_encode([
        'status' => 'error',
        'message' => 'Database error',
        'error' => $e->getMessage()
    ]);
} catch (Exception $e) {
    if ($conn->inTransaction()) {
        $conn->rollBack();
    }
    http_response_code(500);
    echo json_encode([
        'status' => 'error',
        'message' => 'Server error',
        'error' => $e->getMessage()
    ]);
}
?>
