<?php
// Suppress all error output to prevent breaking JSON responses
@ini_set('display_errors', '0');
@ini_set('display_startup_errors', '0');
@error_reporting(0);

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST, GET, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");

$servername = "localhost";
$username = "root";
$password = "";

try {
  $conn = new PDO("mysql:host=$servername;dbname=dblearnsville", $username, $password);
  // set the PDO error mode to exception
  $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
  //  echo "Connected successfully";
} catch(PDOException $e) {
  // Don't output error message directly as it breaks JSON responses
  // Instead, let the calling script handle the error
  error_log("Database connection failed: " . $e->getMessage());
  // Set a flag that can be checked by calling scripts
  $connection_error = $e->getMessage();
  $conn = null; // Ensure $conn is set to null on failure
}